/*
 * Decompiled with CFR 0.152.
 */
package com.github.ehiggs.spark.terasort;

class Unsigned16 {
    private long hi8;
    private long lo8;

    public Unsigned16() {
        this.hi8 = 0L;
        this.lo8 = 0L;
    }

    public Unsigned16(long l) {
        this.hi8 = 0L;
        this.lo8 = l;
    }

    public Unsigned16(Unsigned16 other) {
        this.hi8 = other.hi8;
        this.lo8 = other.lo8;
    }

    public boolean equals(Object o) {
        if (o instanceof Unsigned16) {
            Unsigned16 other = (Unsigned16)o;
            return other.hi8 == this.hi8 && other.lo8 == this.lo8;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.lo8;
    }

    public Unsigned16(String s) throws NumberFormatException {
        this.set(s);
    }

    public void set(String s) throws NumberFormatException {
        this.hi8 = 0L;
        this.lo8 = 0L;
        long lastDigit = -1152921504606846976L;
        for (int i = 0; i < s.length(); ++i) {
            int digit = Unsigned16.getHexDigit(s.charAt(i));
            if ((0xF000000000000000L & this.hi8) != 0L) {
                throw new NumberFormatException(s + " overflowed 16 bytes");
            }
            this.hi8 <<= 4;
            this.hi8 |= (this.lo8 & 0xF000000000000000L) >>> 60;
            this.lo8 <<= 4;
            this.lo8 |= (long)digit;
        }
    }

    public void set(long l) {
        this.lo8 = l;
        this.hi8 = 0L;
    }

    private static int getHexDigit(char ch) throws NumberFormatException {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new NumberFormatException(ch + " is not a valid hex digit");
    }

    public String toString() {
        if (this.hi8 == 0L) {
            return Long.toHexString(this.lo8);
        }
        StringBuilder result = new StringBuilder();
        result.append(Long.toHexString(this.hi8));
        String loString = Long.toHexString(this.lo8);
        for (int i = loString.length(); i < 16; ++i) {
            result.append('0');
        }
        result.append(loString);
        return result.toString();
    }

    public byte getByte(int b) {
        if (b >= 0 && b < 16) {
            if (b < 8) {
                return (byte)(this.hi8 >> 56 - 8 * b);
            }
            return (byte)(this.lo8 >> 120 - 8 * b);
        }
        return 0;
    }

    public char getHexDigit(int p) {
        byte digit = this.getByte(p / 2);
        if (p % 2 == 0) {
            digit = (byte)(digit >>> 4);
        }
        if ((digit = (byte)(digit & 0xF)) < 10) {
            return (char)(48 + digit);
        }
        return (char)(65 + digit - 10);
    }

    public long getHigh8() {
        return this.hi8;
    }

    public long getLow8() {
        return this.lo8;
    }

    void multiply(Unsigned16 b) {
        long[] left = new long[]{this.lo8 & 0xFFFFFFFFL, this.lo8 >>> 32, this.hi8 & 0xFFFFFFFFL, this.hi8 >>> 32};
        long[] right = new long[]{b.lo8 & Integer.MAX_VALUE, b.lo8 >>> 31 & Integer.MAX_VALUE, (b.lo8 >>> 62) + ((b.hi8 & 0x1FFFFFFFL) << 2), b.hi8 >>> 29 & Integer.MAX_VALUE, b.hi8 >>> 60};
        this.set(0L);
        Unsigned16 tmp = new Unsigned16();
        for (int l = 0; l < 4; ++l) {
            for (int r = 0; r < 5; ++r) {
                long prod = left[l] * right[r];
                if (prod == 0L) continue;
                int off = l * 32 + r * 31;
                tmp.set(prod);
                tmp.shiftLeft(off);
                this.add(tmp);
            }
        }
    }

    public void add(Unsigned16 b) {
        long sumHi = this.hi8 + b.hi8;
        long hibit0 = this.lo8 & Long.MIN_VALUE;
        long hibit1 = b.lo8 & Long.MIN_VALUE;
        long sumLo = this.lo8 + b.lo8;
        long reshibit = sumLo & Long.MIN_VALUE;
        if ((hibit0 & hibit1) != 0L | ((hibit0 ^ hibit1) != 0L && reshibit == 0L)) {
            ++sumHi;
        }
        this.hi8 = sumHi;
        this.lo8 = sumLo;
    }

    public void shiftLeft(int bits) {
        if (bits != 0) {
            if (bits < 64) {
                this.hi8 <<= bits;
                this.hi8 |= this.lo8 >>> 64 - bits;
                this.lo8 <<= bits;
            } else if (bits < 128) {
                this.hi8 = this.lo8 << bits - 64;
                this.lo8 = 0L;
            } else {
                this.hi8 = 0L;
                this.lo8 = 0L;
            }
        }
    }
}

