/*
 * Decompiled with CFR 0.152.
 */
package com.github.ehiggs.spark.terasort;

import com.github.ehiggs.spark.terasort.TeraInputFormat;
import com.github.ehiggs.spark.terasort.Unsigned16;
import com.google.common.primitives.UnsignedBytes;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class TeraValidate$ {
    public static TeraValidate$ MODULE$;

    static {
        new TeraValidate$();
    }

    public void main(String[] args) {
        if (args.length < 1) {
            Predef$.MODULE$.println("Usage:");
            Predef$.MODULE$.println("DRIVER_MEMORY=[mem] spark-submit com.github.ehiggs.spark.terasort.TeraValidate spark-terasort-1.0-SNAPSHOT-with-dependencies.jar [input-directory]");
            Predef$.MODULE$.println(" ");
            Predef$.MODULE$.println("Example:");
            Predef$.MODULE$.println("DRIVER_MEMORY=50g spark-submit com.github.ehiggs.spark.terasort.TeraValidate spark-terasort-1.0-SNAPSHOT-with-dependencies.jar file:///scratch/username/terasort_in ");
            System.exit(0);
        }
        String inputFile = args[0];
        SparkConf conf = new SparkConf().set("spark.serializer", "org.apache.spark.serializer.KryoSerializer").setAppName("TeraValidate");
        SparkContext sc = new SparkContext(conf);
        RDD dataset = sc.newAPIHadoopFile(inputFile, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)), ClassTag$.MODULE$.apply(TeraInputFormat.class));
        this.validate(sc, (RDD<Tuple2<byte[], byte[]>>)dataset);
    }

    public void validate(SparkContext sc, RDD<Tuple2<byte[], byte[]>> dataset) {
        RDD output = dataset.mapPartitions((Function1<Iterator, Iterator> & Serializable & scala.Serializable)iter -> {
            Unsigned16 sum = new Unsigned16();
            Unsigned16 checksum = new Unsigned16();
            PureJavaCrc32 crc32 = new PureJavaCrc32();
            byte[] min = new byte[10];
            byte[] max = new byte[10];
            Comparator<byte[]> cmp = UnsignedBytes.lexicographicalComparator();
            long pos = 0L;
            byte[] prev = new byte[10];
            while (iter.hasNext()) {
                byte[] key = (byte[])((Tuple2)iter.next())._1();
                Predef$.MODULE$.assert(cmp.compare(key, prev) >= 0);
                crc32.reset();
                crc32.update(key, 0, key.length);
                checksum.set(crc32.getValue());
                sum.add(checksum);
                if (pos == 0L) {
                    new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(key)).copyToArray(min, 0, 10);
                }
                ++pos;
                prev = key;
            }
            new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(prev)).copyToArray(max, 0, 10);
            return package$.MODULE$.Iterator().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3<Unsigned16, byte[], byte[]>(sum, min, max)}));
        }, true, ClassTag$.MODULE$.apply(Tuple3.class));
        Tuple3[] checksumOutput = (Tuple3[])output.collect();
        Comparator<byte[]> cmp = UnsignedBytes.lexicographicalComparator();
        Unsigned16 sum = new Unsigned16();
        long numRecords = dataset.count();
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])checksumOutput)).foreach((Function1<Tuple3, Object> & Serializable & scala.Serializable)x0$1 -> {
            TeraValidate$.$anonfun$validate$2(sum, x0$1);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println(new StringBuilder(13).append("num records: ").append(numRecords).toString());
        Predef$.MODULE$.println(new StringBuilder(10).append("checksum: ").append(sum.toString()).toString());
        ObjectRef<byte[]> lastMax = ObjectRef.create(new byte[10]);
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])checksumOutput)).map((Function1<Tuple3, Tuple3> & Serializable & scala.Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Unsigned16 partSum = (Unsigned16)tuple3._1();
            byte[] min = (byte[])tuple3._2();
            byte[] max = (byte[])tuple3._3();
            Tuple3<Unsigned16, Object, Object> tuple32 = new Tuple3<Unsigned16, Object, Object>(partSum, min.clone(), max.clone());
            return tuple32;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class))))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> {
            TeraValidate$.$anonfun$validate$4(lastMax, cmp, x0$3);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println(new StringBuilder(13).append("num records: ").append(numRecords).toString());
        Predef$.MODULE$.println(new StringBuilder(10).append("checksum: ").append(sum.toString()).toString());
        Predef$.MODULE$.println("partitions are properly sorted");
    }

    public static final /* synthetic */ void $anonfun$validate$2(Unsigned16 sum$1, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Unsigned16 partSum = (Unsigned16)tuple3._1();
        sum$1.add(partSum);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$validate$5(byte x) {
        return x < 0 ? 256 + x : x;
    }

    public static final /* synthetic */ int $anonfun$validate$6(byte x) {
        return x < 0 ? 256 + x : x;
    }

    public static final /* synthetic */ int $anonfun$validate$7(byte x) {
        return x < 0 ? 256 + x : x;
    }

    public static final /* synthetic */ void $anonfun$validate$4(ObjectRef lastMax$1, Comparator cmp$1, Tuple2 x0$3) {
        int i;
        Tuple3 tuple3;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$3;
                if (tuple2 == null) break block2;
                tuple3 = (Tuple3)tuple2._1();
                i = tuple2._2$mcI$sp();
                if (tuple3 != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        byte[] min = (byte[])tuple3._2();
        byte[] max = (byte[])tuple3._3();
        Predef$.MODULE$.println(new StringBuilder(5).append("part ").append(i).toString());
        Predef$.MODULE$.println(new StringBuilder(7).append("lastMax").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])lastMax$1.elem)).toSeq().map((Function1<Object, Object> & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger(TeraValidate$.$anonfun$validate$5(BoxesRunTime.unboxToByte(x))), Seq$.MODULE$.canBuildFrom())).toString());
        Predef$.MODULE$.println(new StringBuilder(4).append("min ").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(min)).toSeq().map((Function1<Object, Object> & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger(TeraValidate$.$anonfun$validate$6(BoxesRunTime.unboxToByte(x))), Seq$.MODULE$.canBuildFrom())).toString());
        Predef$.MODULE$.println(new StringBuilder(4).append("max ").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(max)).toSeq().map((Function1<Object, Object> & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger(TeraValidate$.$anonfun$validate$7(BoxesRunTime.unboxToByte(x))), Seq$.MODULE$.canBuildFrom())).toString());
        Predef$.MODULE$.assert(cmp$1.compare(min, max) <= 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "min >= max");
        Predef$.MODULE$.assert(cmp$1.compare((byte[])lastMax$1.elem, min) <= 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "current partition min < last partition max");
        lastMax$1.elem = max;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private TeraValidate$() {
        MODULE$ = this;
    }
}

