/*
 * Decompiled with CFR 0.152.
 */
package com.github.ehiggs.spark.terasort;

import com.github.ehiggs.spark.terasort.TeraInputFormat;
import com.github.ehiggs.spark.terasort.TeraOutputFormat;
import com.github.ehiggs.spark.terasort.TeraSortPartitioner;
import com.google.common.primitives.UnsignedBytes;
import java.util.Comparator;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Predef$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class TeraSort$ {
    public static TeraSort$ MODULE$;
    private final Comparator<byte[]> caseInsensitiveOrdering;

    static {
        new TeraSort$();
    }

    public Comparator<byte[]> caseInsensitiveOrdering() {
        return this.caseInsensitiveOrdering;
    }

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println("Usage:");
            Predef$.MODULE$.println("DRIVER_MEMORY=[mem] spark-submit com.github.ehiggs.spark.terasort.TeraSort spark-terasort-1.0-SNAPSHOT-with-dependencies.jar [input-file] [output-file]");
            Predef$.MODULE$.println(" ");
            Predef$.MODULE$.println("Example:");
            Predef$.MODULE$.println("DRIVER_MEMORY=50g spark-submit com.github.ehiggs.spark.terasort.TeraSort spark-terasort-1.0-SNAPSHOT-with-dependencies.jar /home/myuser/terasort_in /home/myuser/terasort_out");
            System.exit(0);
        }
        String inputFile = args[0];
        String outputFile = args[1];
        SparkConf conf = new SparkConf().set("spark.serializer", "org.apache.spark.serializer.KryoSerializer").setAppName("TeraSort");
        SparkContext sc = new SparkContext(conf);
        RDD dataset = sc.newAPIHadoopFile(inputFile, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)), ClassTag$.MODULE$.apply(TeraInputFormat.class));
        RDD sorted = RDD$.MODULE$.rddToOrderedRDDFunctions(dataset, Ordering$.MODULE$.comparatorToOrdering(this.caseInsensitiveOrdering()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))).repartitionAndSortWithinPartitions((Partitioner)new TeraSortPartitioner(dataset.partitions().length));
        RDD$.MODULE$.rddToPairRDDFunctions(sorted, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)), Ordering$.MODULE$.comparatorToOrdering(this.caseInsensitiveOrdering())).saveAsNewAPIHadoopFile(outputFile, ClassTag$.MODULE$.apply(TeraOutputFormat.class));
        sc.stop();
    }

    private TeraSort$() {
        MODULE$ = this;
        this.caseInsensitiveOrdering = UnsignedBytes.lexicographicalComparator();
    }
}

