/*
 * Decompiled with CFR 0.152.
 */
package com.github.ehiggs.spark.terasort;

import com.github.ehiggs.spark.terasort.Random16;
import com.github.ehiggs.spark.terasort.TeraInputFormat$;
import com.github.ehiggs.spark.terasort.TeraOutputFormat;
import com.github.ehiggs.spark.terasort.Unsigned16;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class TeraGen$ {
    public static TeraGen$ MODULE$;

    static {
        new TeraGen$();
    }

    public void main(String[] args) {
        RDD dataset;
        if (args.length < 2) {
            Predef$.MODULE$.println("Usage:");
            Predef$.MODULE$.println("DRIVER_MEMORY=[mem] spark-submit com.github.ehiggs.spark.terasort.TeraGen spark-terasort-1.0-SNAPSHOT-with-dependencies.jar [output-size] [output-directory]");
            Predef$.MODULE$.println(" ");
            Predef$.MODULE$.println("Example:");
            Predef$.MODULE$.println("DRIVER_MEMORY=50g spark-submit com.github.ehiggs.spark.terasort.TeraGen spark-terasort-1.0-SNAPSHOT-with-dependencies.jar 100G file:///scratch/username/terasort_in");
            System.exit(0);
        }
        long outputSizeInBytes = this.sizeStrToBytes(args[0]);
        String outputFile = args[1];
        String size = this.sizeToSizeStr(outputSizeInBytes);
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(10).append("TeraGen (").append(size).append(")").toString());
        SparkContext sc = new SparkContext(conf);
        int parts = sc.defaultParallelism();
        long recordsPerPartition = outputSizeInBytes / 100L / (long)parts;
        long numRecords = recordsPerPartition * (long)parts;
        Predef$.MODULE$.println("===========================================================================");
        Predef$.MODULE$.println("===========================================================================");
        Predef$.MODULE$.println(new StringBuilder(12).append("Input size: ").append(size).toString());
        Predef$.MODULE$.println(new StringBuilder(25).append("Total number of records: ").append(numRecords).toString());
        Predef$.MODULE$.println(new StringBuilder(29).append("Number of output partitions: ").append(parts).toString());
        Predef$.MODULE$.println(new StringBuilder(36).append("Number of records/output partition: ").append(numRecords / (long)parts).toString());
        Predef$.MODULE$.println("===========================================================================");
        Predef$.MODULE$.println("===========================================================================");
        Predef$.MODULE$.assert(recordsPerPartition < Integer.MAX_VALUE, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(24).append("records per partition > ").append(Integer.MAX_VALUE).toString());
        RDD qual$1 = sc.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), parts), parts, ClassTag$.MODULE$.Int());
        Function2<Object, Iterator, Iterator> & Serializable & scala.Serializable x$1 = (Function2<Object, Iterator, Iterator> & Serializable & scala.Serializable)(x0$1, x1$1) -> TeraGen$.$anonfun$main$2(recordsPerPartition, BoxesRunTime.unboxToInt(x0$1), x1$1);
        boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
        RDD x$3 = dataset = qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$4 = ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE));
        ClassTag x$5 = ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE));
        Null$ x$6 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$3);
        RDD$.MODULE$.rddToPairRDDFunctions(x$3, x$4, x$5, null).saveAsNewAPIHadoopFile(outputFile, ClassTag$.MODULE$.apply(TeraOutputFormat.class));
        Predef$.MODULE$.println(new StringBuilder(27).append("Number of records written: ").append(dataset.count()).toString());
    }

    public long sizeStrToBytes(String str) {
        String lower = str.toLowerCase();
        return lower.endsWith("k") ? new StringOps(Predef$.MODULE$.augmentString(lower.substring(0, lower.length() - 1))).toLong() * 1000L : (lower.endsWith("m") ? new StringOps(Predef$.MODULE$.augmentString(lower.substring(0, lower.length() - 1))).toLong() * 1000L * 1000L : (lower.endsWith("g") ? new StringOps(Predef$.MODULE$.augmentString(lower.substring(0, lower.length() - 1))).toLong() * 1000L * 1000L * 1000L : (lower.endsWith("t") ? new StringOps(Predef$.MODULE$.augmentString(lower.substring(0, lower.length() - 1))).toLong() * 1000L * 1000L * 1000L * 1000L : new StringOps(Predef$.MODULE$.augmentString(lower)).toLong())));
    }

    public String sizeToSizeStr(long size) {
        long kbScale = 1000L;
        long mbScale = 1000L * kbScale;
        long gbScale = 1000L * mbScale;
        long tbScale = 1000L * gbScale;
        return size > tbScale ? new StringBuilder(2).append(size / tbScale).append("TB").toString() : (size > gbScale ? new StringBuilder(2).append(size / gbScale).append("GB").toString() : (size > mbScale ? new StringBuilder(2).append(size / mbScale).append("MB").toString() : (size > kbScale ? new StringBuilder(2).append(size / kbScale).append("KB").toString() : new StringBuilder(1).append(size).append("B").toString())));
    }

    public void generateRecord(byte[] recBuf, Unsigned16 rand, Unsigned16 recordNumber) {
        int i;
        for (i = 0; i < 10; ++i) {
            recBuf[i] = rand.getByte(i);
        }
        recBuf[10] = (byte)0;
        recBuf[11] = (byte)17;
        for (i = 0; i < 32; ++i) {
            recBuf[12 + i] = (byte)recordNumber.getHexDigit(i);
        }
        recBuf[44] = (byte)136;
        recBuf[45] = (byte)153;
        recBuf[46] = (byte)170;
        recBuf[47] = (byte)187;
        for (i = 0; i < 12; ++i) {
            byte v;
            recBuf[48 + i * 4] = v = (byte)rand.getHexDigit(20 + i);
            recBuf[49 + i * 4] = v;
            recBuf[50 + i * 4] = v;
            recBuf[51 + i * 4] = v;
        }
        recBuf[96] = (byte)204;
        recBuf[97] = (byte)221;
        recBuf[98] = (byte)238;
        recBuf[99] = (byte)255;
    }

    public static final /* synthetic */ Tuple2 $anonfun$main$3(Unsigned16 rand$1, byte[] rowBytes$1, Unsigned16 recordNumber$1, Unsigned16 one$1, byte[] key$1, byte[] value$1, int offset) {
        Random16.nextRand(rand$1);
        MODULE$.generateRecord(rowBytes$1, rand$1, recordNumber$1);
        recordNumber$1.add(one$1);
        new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(rowBytes$1)).copyToArray(key$1, 0, TeraInputFormat$.MODULE$.KEY_LEN());
        new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(rowBytes$1)).takeRight(TeraInputFormat$.MODULE$.VALUE_LEN()))).copyToArray(value$1, 0, TeraInputFormat$.MODULE$.VALUE_LEN());
        return new Tuple2<byte[], byte[]>(key$1, value$1);
    }

    public static final /* synthetic */ Iterator $anonfun$main$2(long recordsPerPartition$1, int x0$1, Iterator x1$1) {
        Tuple2<Integer, Iterator> tuple2 = new Tuple2<Integer, Iterator>(BoxesRunTime.boxToInteger(x0$1), x1$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int index = tuple2._1$mcI$sp();
        Unsigned16 one = new Unsigned16(1L);
        Unsigned16 firstRecordNumber = new Unsigned16((long)index * recordsPerPartition$1);
        Unsigned16 recordsToGenerate = new Unsigned16(recordsPerPartition$1);
        Unsigned16 recordNumber = new Unsigned16(firstRecordNumber);
        Unsigned16 lastRecordNumber = new Unsigned16(firstRecordNumber);
        lastRecordNumber.add(recordsToGenerate);
        Unsigned16 rand = Random16.skipAhead(firstRecordNumber);
        byte[] rowBytes = new byte[TeraInputFormat$.MODULE$.RECORD_LEN()];
        byte[] key = new byte[TeraInputFormat$.MODULE$.KEY_LEN()];
        byte[] value = new byte[TeraInputFormat$.MODULE$.VALUE_LEN()];
        Iterator iterator = package$.MODULE$.Iterator().tabulate((int)recordsPerPartition$1, (Function1<Object, Tuple2> & Serializable & scala.Serializable)offset -> TeraGen$.$anonfun$main$3(rand, rowBytes, recordNumber, one, key, value, BoxesRunTime.unboxToInt(offset)));
        return iterator;
    }

    private TeraGen$() {
        MODULE$ = this;
    }
}

